#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Kaleidoscope TripMod01.fsh   by  PixelPhil
//https://www.shadertoy.com/view/....
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


vec3 N13(float p) {
    //  from DAVE HOSKINS
   vec3 p3 = fract(vec3(p) * vec3(.1031,.11369,.13787));
   p3 += dot(p3, p3.yzx + 19.19);
   return fract(vec3((p3.x + p3.y)*p3.z, (p3.x+p3.z)*p3.y, (p3.y+p3.z)*p3.x));
}

vec4 N14(float t) {
	return fract(sin(t*vec4(123., 1024., 1456., 264.))*vec4(6547., 345., 8799., 1564.));
}
float N(float t) {
    return fract(sin(t*12345.564)*7658.76);
}

vec3 ChromaColor(float a)
{
    return (vec3(sin(a), sin(a + 1.52), sin(a + 3.14)) * 0.8) + 0.5;
}

// A cellular voronoi with smooth boundaries and trippy colors
vec3 voronoi(vec2 pearlsUv, float colorOffset)
{    
    vec2 pearlsId =  floor(pearlsUv);
     
    pearlsUv = fract(pearlsUv);
    
    
    vec3 chroma;
    float bestlen = 1000.0;
    
    for (float y = -1.0; y <= 1.0; y++)
    {
        for (float x = -1.0; x <= 1.0; x++)
        {
            vec2 offset =  vec2(x, y);
            vec2 cellId = pearlsId - offset;
            vec3 rnd = N13(cellId.x * 34.0 + cellId.y * 345.0);
            vec2 center = rnd.xy - offset;
            
            center.x += sin(iTime * rnd.x) * 0.3;
            center.y += sin(iTime * rnd.y) * 0.3;

            float len = length(center - (pearlsUv));
            
            float diff = bestlen - len;
            
        	float thres = 0.04;    
        	float ratio = (diff + thres) / (2.0 * thres);
            
            if (ratio > 0.0)
            {
                bestlen = len;
                vec3 col =  ChromaColor(rnd.z * 100.0 + len * 0.5 + colorOffset);
	            chroma = mix(chroma, col, min(ratio, 1.0));
            }
        }
    }
    
    return chroma;
}

vec2 mirror(vec2 uv, vec2 origin, vec2 dir)
{
    vec2 offset = uv - origin;
    float d = dot(offset, dir);
    if (d < 0.0)
    {
        return uv - dir * (2.0 * d);
    }
    return uv;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = (2.0*fragCoord-iResolution.xy)/iResolution.y;
    
    float rot = iTime * 0.21;
    float s = sin(rot);
    float c = cos(rot);
    mat2 rotMat = mat2(s,c,-c,s);
    uv = uv * rotMat;
    
    
    
    float centerDst = length(uv);
    
    float distort = centerDst * centerDst;
    
    uv = abs(uv * (1.0 - distort * 0.2));

    float t1 = iTime * 0.14;
    float t2 = iTime * 0.2 + 23.0;
    float t3 = -iTime * 0.24 + 56.0;
    

    uv = mirror(uv, vec2(0.2, 0.7), vec2(sin(t2), cos(t2)));
    uv = mirror(uv, vec2(0.4, 0.3), vec2(sin(t3), cos(t3)));
    uv = mirror(uv, vec2(0.5, 0.5), vec2(sin(t1), cos(t1)));
    
    // Time varying pixel color

    vec2 pearlsUv = uv * 10.0 + sin(iTime) * 1.5;
    
    pearlsUv.y += iTime * 2.0;
    
    
 

	vec3 chroma = voronoi(pearlsUv, centerDst * 6.0) * smoothstep(1.5, 0.7, centerDst);

    // Output to screen
    fragColor = vec4(chroma,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

